#include "sprig.h"
#include "Treasure.h"


Chest::Chest()
    : type(ISLAND)
    , x(0), y(0)
    , map(NULL)
    , gold(0)
    , isOpen(false)
    , pic(NULL)
    , picOpen(NULL)
{}

void Chest::draw(SDL_Surface* screen, float scrollX, float scrollY)
{
    if(type == ISLAND)
    {
        if(!isOpen)
            SPG_Draw(pic, screen, x - scrollX - pic->w/2, y - scrollY - pic->h/2);
        else
            SPG_Draw(picOpen, screen, x - scrollX - picOpen->w/2, y - scrollY - picOpen->h/2);
        //SPG_RectFilled(screen, x - scrollX, y - scrollY, x + 40 - scrollX, y + 20 - scrollY, SDL_MapRGB(screen->format, 160, 140, 10));
    }
    else
        SPG_Circle(screen, x - scrollX, y - scrollY, 30, SDL_MapRGB(screen->format, 255, 255, 0));
}




Map::Map()
    : target(NULL)
    , pic(NULL)
    , bigpic(NULL)
    , x(0), y(0)
{}

void drawX(SDL_Surface* screen, float x, float y)
{
    SPG_PushThickness(2);
    SPG_Line(screen, x - 4, y - 4, x + 4, y + 4, SDL_MapRGB(screen->format, 150, 0, 0));
    SPG_Line(screen, x - 4, y + 4, x + 4, y - 4, SDL_MapRGB(screen->format, 150, 0, 0));
    SPG_PopThickness();
}

void Map::draw(SDL_Surface* screen, GameState* state)
{
    int w = 150;
    int h = 150;
    int offsetX = screen->w - w;
    int offsetY = screen->h - h;
    
    //SDL_Surface* bigmap = SPG_Scale(pic, float(w)/pic->w, float(h)/pic->h);
    //bigmap = SPG_DisplayFormat(bigmap);
    //SDL_SetAlpha(bigmap, SDL_SRCALPHA, 100);
    //SPG_Draw(bigmap, screen, offsetX, offsetY);
    //SDL_FreeSurface(bigmap);
    SPG_Draw(bigpic, screen, offsetX, offsetY);
    SPG_Circle(screen, offsetX + (state->player->boat->x)/state->smaxX * w, offsetY + (state->player->boat->y)/state->smaxY * h, 4, SDL_MapRGB(screen->format, 0, 200, 0));
    if(target != NULL)
        drawX(screen, offsetX + (target->x)/state->smaxX * w, offsetY + (target->y)/state->smaxY * h);
}

