#include "Projectile.h"
#include "sprig.h"
#include <cmath>

#define A_GRAVITY 1200

CannonBall::CannonBall(Boat* boat)
    : owner(boat)
    , x(boat->x), y(boat->y), z(0)
{
    // Figure out the params from the target point: (target.x, target.y, target.z)
    // Kinematics and algebra give:
    //           v0x*v0z = (a/2)*(x0 - x)
    // x is a vector, which represents both x and y in the code below.
    float angle = atan2(boat->target.y - boat->y, boat->target.x - boat->x);
    float xx = boat->x - boat->target.x;
    float yy = boat->y - boat->target.y;
    float velXYZ = (A_GRAVITY/2)*sqrt(xx*xx + yy*yy);
    velx = sqrt(velXYZ)/2*cos(angle);
    vely = sqrt(velXYZ)/2*sin(angle);
    velz = sqrt(velXYZ)*2;
    
    pic = boat->ball;
}

bool CannonBall::update(float dt)
{
    x += velx*dt;
    y += vely*dt;
    z += velz*dt;
    
    velz -= A_GRAVITY*dt;
    
    if(z <= 0)
        return false;
    return true;
}


void CannonBall::draw(SDL_Surface* screen, float scrollX, float scrollY)
{
    SPG_Draw(pic, screen, x - scrollX - pic->w/2, y - scrollY - pic->h/2 - z/2);
    SPG_EllipseFilledBlend(screen, x - scrollX - 10, y - scrollY - 10, 20, 10, 0x000000, 50);
}




Splash::Splash(float x, float y)
    : x(x), y(y), timer(1.0f)
{}

Splash::~Splash()
{}

bool Splash::update(float dt)
{
    timer -= dt;
    return (timer > 0);
}

void Splash::draw(SDL_Surface* screen, float scrollX, float scrollY)
{
    SPG_EllipseFilledBlend(screen, x - scrollX - 10, y - scrollY - 10, 40*(1-timer) + 10, 20*(1-timer) + 5, SDL_MapRGB(screen->format, 0, 0, 200), 50);
}


Blast::Blast(float x, float y)
    : Splash(x, y)
{
    timer = 0.2f;
}

Blast::~Blast()
{}

/*bool Blast::update(float dt)
{
    timer -= dt;
    return (timer > 0);
}*/

void Blast::draw(SDL_Surface* screen, float scrollX, float scrollY)
{
    //printf("Drawing BLAST\n");
    SPG_EllipseFilledBlend(screen, x - scrollX - 10, y - scrollY - 10, 40*(1-timer) + 5, 20*(1-timer) + 5, SDL_MapRGB(screen->format, 200, 0, 0), 200);
}
