#ifndef _PLAYER_H__
#define _PLAYER_H__

#include "Libraries/StickyInput.h"
using namespace SI;


class GameState;
class Boat;
class Island;
#include "Boat.h"
#include "Island.h"

class Player
{
    public:
    
    Boat* boat;
    Controller controls;
    unsigned int b_up, b_down, b_left, b_right, b_fire, b_anchor;
    unsigned int b_up2, b_down2, b_left2, b_right2, b_fire2, b_anchor2;
    
    Player();
    ~Player();
    
    void update(GameState* state);
    
    bool checkInput(SDL_Event& event, GameState* state);
};

class CPU
{
    public:
    
    Boat* boat;
    
    CPU();
    ~CPU();
    
    void update(GameState* state);
    
    // AI actions
    void chase(GameState* state, float x, float y);
    void circle(GameState* state, Boat* target);
    void attack(GameState* state, Boat* target);
    void attack(GameState* state, Island* target);
};

#include "Game.h"


#endif
