#include "Island.h"

#include "sprig.h"



Island::Island(float x, float y)
    : x(x), y(y), radius(78), hp(5), chest(NULL)
{
    
}

void Island::draw(SDL_Surface* screen, float scrollX, float scrollY)
{
    if(hp > 0)
        SPG_Draw(pic, screen, x - scrollX - 190, y - scrollY - 306);
    else
        SPG_Draw(picBroke, screen, x - scrollX - 190, y - scrollY - 306);
    
    if(chest != NULL)
        chest->draw(screen, scrollX - 40, scrollY - 40);
}

void Island::drawFore(SDL_Surface* screen, float scrollX, float scrollY)
{
    if(hp > 0)
        SPG_Draw(fore, screen, x - scrollX - 190, y - scrollY - 306);
    else
        SPG_Draw(foreBroke, screen, x - scrollX - 190, y - scrollY - 306);
}

 //190 306 is center of island pic
 
void Island::hit()
{
    if(chest != NULL)
        chest->isOpen = true;
    hp--;
}
