#ifndef _GAME_H__
#define _GAME_H__

#include "Libraries/PL_Loop.h"
#include "Libraries/NFont.h"
#include "Player.h"
#include "Boat.h"
#include "Island.h"
#include "Projectile.h"
class Chest;

#include <vector>
#include <list>

using namespace PL;
using std::vector;
using std::list;

class CannonBall;
class Splash;
class Player;
class CPU;
class Island;

class GameState : public PL_State
{
    public:

    float scrollX, scrollY;
    Player* player;
    vector<CPU*> cpus;
    vector<Boat*> boats;
    vector<Island*> islands;
    list<CannonBall*> balls;
    list<Splash*> splashes;
    list<Map*> floatingMaps;
    list<Chest*> underwaterChests;
    float sminX, sminY, smaxX, smaxY;  // Scroll boundaries
    float minX, minY, maxX, maxY;  // Boat boundaries

    GameState();


};


class GameUpdate : public PL_Update
{
    public:

    GameUpdate();

    void update(PL_State* state);

};


class GameDraw : public PL_Draw
{
    public:

    SDL_Surface* tub;
    SDL_Surface* tubFore;
    SDL_Surface* spoutFore;

    NFont* font1;
    NFont* font2;

    GameDraw();

    void draw(PL_State* state);

};


class GameEvent : public PL_AnyEvent
{
    public:
    GameEvent();

    bool handleEvent(PL_State* state, SDL_Event& event);

};






#endif
