#ifndef _BOAT_H__
#define _BOAT_H__

#include "SDL.h"
#include "Point2D.h"
#include "Game.h"
class Map;
#include "Treasure.h"
#include <list>
using std::list;

class Boat
{
    public:
    float x, y;
    float velx, vely;
    float accelx, accely;
    float angle;
    float maxVel;
    SDL_Surface* pic[8];
    Point2D target;
    int team;
    float shotTimer;
    float shotTimerMax;
    
    int hp, hpMax;
    int gold;
    SDL_Surface* ball;
    bool isPlayer;
    
    float anchorTimer;
    float invinceTimer;
    SDL_Surface* hook;
    
    list<Map*> maps;
    
    
    Boat();
    
    void draw(SDL_Surface* screen, float scrollX, float scrollY);
    
    void update(float dt);
    
    void fire(GameState* state);
    
    void tossAnchor(GameState* state);
    
    void hit();
};





#endif
