#include "Boat.h"
#include "sprig.h"
#include "Libraries/MixBox.h"
#include "extraMath.h"
#include <cmath>


Boat::Boat()
    : x(0), y(0)
    , velx(0), vely(0)
    , accelx(0), accely(0)
    , angle(0)
    , maxVel(300)
    , team(0)
    , shotTimer(-1)
    , shotTimerMax(0.4f)
    , hp(0)
    , hpMax(5)
    , gold(0)
    , ball(NULL)
    , isPlayer(false)
    , anchorTimer(-1)
    , invinceTimer(-1)
{
    static int teamCounter = 0;
    team = teamCounter++;
    hp = hpMax;
}

void Boat::draw(SDL_Surface* screen, float scrollX, float scrollY)
{
    if(hp <= 0)
        return;
    
    if(invinceTimer < 0 || SDL_GetTicks()%400 > 200)
    {
        int picnum = 0;
        
        if(PI_2 - PI_8 < angle && angle < PI_2 + PI_8)
            picnum = 0;
        else if(PI3_4 - PI_8 < angle && angle < PI3_4 + PI_8)
            picnum = 7;
        else if(PI - PI_8 < angle && angle < PI + PI_8)
            picnum = 6;
        else if(PI5_4 - PI_8 < angle && angle < PI5_4 + PI_8)
            picnum = 5;
        else if(PI3_2 - PI_8 < angle && angle < PI3_2 + PI_8)
            picnum = 4;
        else if(PI7_4 - PI_8 < angle && angle < PI7_4 + PI_8)
            picnum = 3;
        else if(PI7_4 + PI_8 < angle || angle < PI_4 - PI_8)
            picnum = 2;
        else if(PI_4 - PI_8 < angle && angle < PI_4 + PI_8)
            picnum = 1;
        
        SPG_Draw(pic[picnum], screen, x - scrollX - pic[picnum]->w/2, y - scrollY - pic[picnum]->h/2);
        
        if(anchorTimer >= 0)
            SPG_Draw(hook, screen, x - scrollX - hook->w/2, y - scrollY - hook->h - pic[picnum]->h/2 - 30);
    }
    
    
    if(isPlayer)
        SPG_Circle(screen, target.x - scrollX, target.y - scrollY, 20, 0x000000);
}

void Boat::fire(GameState* state)
{
    if(shotTimer < 0)
    {
        state->balls.push_back(new CannonBall(this));// fire!
        
        MB::MixBox::instance().play(MB::SoundID(rand()%3+3));
        shotTimer = shotTimerMax;
    }
}

void Boat::tossAnchor(GameState* state)
{
    if(anchorTimer < 0)
    {
        anchorTimer = 2.0f;
        
        // Search for a chest!
        bool alldone = false;
        for(list<Chest*>::iterator e = state->underwaterChests.begin(); e != state->underwaterChests.end(); e++)
        {
            if(dist(this, *e) < 75)
            {
                for(list<Map*>::iterator f = maps.begin(); f != maps.end(); f++)
                {
                    if((*f)->target == *e)
                    {
                        // Got it!
                        if((*e)->map != NULL)
                            maps.push_back((*e)->map);
                            
                        gold += (*e)->gold;
                        
                        (*e)->gold = 0;
                        (*e)->map = NULL;
                        
                        delete *f;
                        delete *e;
                        maps.erase(f);
                        state->underwaterChests.erase(e);
                        alldone = true;
                        break;
                    }
                }
                
                if(alldone)
                    break;
            }
        }
        
    }
}

void Boat::update(float dt)
{
	float vel = sqrt(velx*velx + vely*vely);
	float velDir = atan2(vely, velx);
    if(vel > maxVel)
    {
        vel = maxVel;
		velx = vel*cos(velDir);
		vely = vel*sin(velDir);
    }
    
    x += velx*dt;
    y += vely*dt;
        
    
	vel = sqrt(velx*velx + vely*vely);
	if(anchorTimer < 0)
	{
        vel -= 0.5f*vel*dt;
	}
	else
	{
	    anchorTimer -= dt;
        vel -= 200.0f*vel*dt;
	}
	if(invinceTimer >= 0)
	{
        invinceTimer -= dt;
	}
	if(vel < 0)
		vel = 0;
	velx = vel*cos(velDir);
	vely = vel*sin(velDir);
	
	if(vel > 0)
		angle = atan2(vely, velx);
		
    while(angle > PI2)
        angle -= PI2;
    while(angle < 0)
        angle += PI2;
    
    shotTimer -= dt;
}

void Boat::hit()
{
    hp--;
    invinceTimer = 0.3f;
    if(hp <= 0)
        ; // Boom
}
